

#include "../MeetingServiceImpl.h"
#include "MeetingAccountControllerImpl.h"
#include "MeetingSiteStorager.h"
#include "boost/bind.hpp"
#include "boost/function.hpp"
#include "jcfcoreutils/StringUtils.h"
#include "csfunified/framework/ServicesDispatcher.h"
#include "csfunified/framework/FunctorTask.h"
#include "jcfcoreutils/FunctionTask.h"
#include "../JabberServiceProvider.h"
#include "MeetingSiteImpl.h"


namespace CSFUnified {
    
	static CSFLogger* jcfMeetingLogger = CSFLogger_getLogger("MeetingService-MeetingAccountControllerImpl");
	
	MeetingAccountControllerImpl::MeetingAccountControllerImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory) : MeetingAccountControllerBaseImpl(unifiedFactory)
    {
		CSFLogDebugS(jcfMeetingLogger, "MeetingAccountControllerImpl::MeetingAccountControllerImpl");
		m_bTimerStarted = false;
    }
    
    MeetingAccountControllerImpl::~MeetingAccountControllerImpl()
    {
		CSFLogDebugS(jcfMeetingLogger, "MeetingAccountControllerImpl::~MeetingAccountControllerImpl");
	}
    
    MeetingAccountControllerImpl * MeetingAccountControllerImpl::getInstance()
    {
        static MeetingAccountControllerImpl * s_maAccount;
        if (NULL == s_maAccount)
        {
            s_maAccount = new MeetingAccountControllerImpl(JabberServiceProvider::getInstance().getUnifiedFactory());
        }
        
        return s_maAccount;
    }

    void MeetingAccountControllerImpl::networkChanged(bool bConnected)
    {
        if (bConnected)
        {
            start();
        }
        else
        {
            stop();
        }
    }
    
    void MeetingAccountControllerImpl::start()
    {
		if (!m_bTimerStarted)
		{
			CSFLogDebugS(jcfMeetingLogger, "MeetingAccountControllerImpl::start");
			MeetingSiteStorager::getInstance()->start();
			m_bTimerStarted = true;
		}
	}
    
    void MeetingAccountControllerImpl::stop()
    {
        if (m_bTimerStarted) 
		{
			CSFLogDebugS(jcfMeetingLogger, "MeetingAccountControllerImpl::stop");
			MeetingSiteStorager::getInstance()->stop();
            m_bTimerStarted = false;
        }
    }
    
    void MeetingAccountControllerImpl::registerMeetingAccountCallback(SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountCallback> meetingAccountCallback)
    {
		CSFLogDebugS(jcfMeetingLogger, "MeetingAccountControllerImpl::registerMeetingAccountCallback");
		m_maCallback = meetingAccountCallback.get();
    }
    
    void MeetingAccountControllerImpl::unregisterMeetingAccountCallback(SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountCallback> meetingAccountCallback)
    {
		CSFLogDebugS(jcfMeetingLogger, "MeetingAccountControllerImpl::unregisterMeetingAccountCallback");
		m_maCallback = NULL;
    }

	bool MeetingAccountControllerImpl::isReady()
	{
		return MeetingSiteStorager::getInstance()->isReady();
	}

	bool MeetingAccountControllerImpl::isActive()
	{
		return MeetingSiteStorager::getInstance()->isActive();
	}
    
    int MeetingAccountControllerImpl::getMeetingSiteCount()
    {
        return MeetingSiteStorager::getInstance()->getCount();
    }
    
    SMART_PTR_NS::shared_ptr<CSFUnified::MeetingSite> MeetingAccountControllerImpl::getMeetingSiteByIndex(int index)
    {
        return MeetingSiteStorager::getInstance()->getSiteByIndex(index);
    }

	SMART_PTR_NS::shared_ptr<CSFUnified::MeetingSite> MeetingAccountControllerImpl::getDefaultMeetingSite()
	{
		return MeetingSiteStorager::getInstance()->getDefaultSite();
	}

    
    void MeetingAccountControllerImpl::checkSSOSite(std::string siteUrl)
    {
        MeetingSiteStorager::getInstance()->checkSSOInfo(siteUrl);
    }

	int MeetingAccountControllerImpl::isSSOSite(std::string siteUrl)
	{
		return MeetingSiteStorager::getInstance()->isSSOSite(siteUrl);
	}
    
    void MeetingAccountControllerImpl::removeSite(std::string siteUrl)
    {
        return MeetingSiteStorager::getInstance()->deleteSite(siteUrl);
    }
    
    void MeetingAccountControllerImpl::setActiveSite(std::string siteUrl, std::string userName, const csf::SecureString& userPass)
    {
        SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site;
        site.reset(new MeetingSiteImpl());
        site->setSiteUrl(siteUrl);
        site->setUserName(userName);
        site->setPassword(userPass);
        site->setSSOFlag(false);
        MeetingSiteStorager::getInstance()->setActiveSite(site, "", 0);
    }
                      
    void MeetingAccountControllerImpl::setActiveSite(std::string siteUrl, std::string userName, std::string sessionTicket, long keepAliveTime)
    {
        SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site;
        site.reset(new MeetingSiteImpl());
        site->setSiteUrl(siteUrl);
        site->setUserName(userName);
        site->setSSOFlag(true);
        MeetingSiteStorager::getInstance()->setActiveSite(site, sessionTicket, keepAliveTime);
    }
    
    int MeetingAccountControllerImpl::getSiteLastError()
    {
		return MeetingSiteStorager::getInstance()->getSiteLastError();
    }

	std::string MeetingAccountControllerImpl::getSiteLastErrorMessage()
	{
		return MeetingSiteStorager::getInstance()->getSiteLastErrorMessage();
	}


    
	void MeetingAccountControllerImpl::fire_onMeetingSiteActived(bool activeFlag, std::string siteUrl, SMART_PTR_NS::shared_ptr<CSFUnified::MeetingSite> site)
    {
		CSFLogDebugS(jcfMeetingLogger, "MeetingAccountControllerImpl::fire_onMeetingSiteActived");
		if (NULL != m_maCallback)
        {
			m_maCallback->onMeetingSiteActived(activeFlag, siteUrl, site);
        }
    }
    
    void MeetingAccountControllerImpl::fire_onSSOSiteChecked(std::string siteUrl, int ssoFlag)
    {
		CSFLogDebugS(jcfMeetingLogger, "MeetingAccountControllerImpl::fire_onSSOSiteChecked");
		if (NULL != m_maCallback)
        {
            m_maCallback->onSSOSiteChecked(siteUrl, ssoFlag);
        }
    }
    
    void MeetingAccountControllerImpl::fire_onMeetingSiteRemoved(std::string siteUrl)
    {
		CSFLogDebugS(jcfMeetingLogger, "MeetingAccountControllerImpl::fire_onMeetingSiteRemoved");
		if (NULL != m_maCallback)
        {
            m_maCallback->onMeetingSiteRemoved(siteUrl);
        }
    }
    
    void MeetingAccountControllerImpl::fire_requireRefreshSessionTicket(std::string siteUrl, bool refresh)
    {
		CSFLogDebugS(jcfMeetingLogger, "MeetingAccountControllerImpl::fire_requireRefreshSessionTicket");
		if (NULL != m_maCallback)
        {
            m_maCallback->requireRefreshSessionTicket(siteUrl, refresh);
        }
    }
}
